/*
 * control.h
 *
 *  Created on: Apr 6, 2015
 *      Author: Jordan
 */

#ifndef USER_CODE_CONTROL_H_
#define USER_CODE_CONTROL_H_

#define REF_DEBUG 0
#define MOTOR_DEBUG 0
#define CONTROLS_DEBUG 0
#define CONTROLS_DEBUG2 0

#define IDLE_THR 1.15

#define FS 50

#define PI 3.141592653

#define PID_PARAMS_ADDR 0

#define RATE_P_INC 0.005
#define RATE_I_INC 0.005
#define RATE_D_INC 0.0005
#define ANGLE_P_INC 0.1
#define ANGLE_I_INC 0.01
#define ANGLE_D_INC 0.01

#define DEF_ROLL_RATE_P 0.0814044317697523
#define DEF_ROLL_RATE_I 0.00870812929848287
#define DEF_ROLL_RATE_D 0
#define ROLL_RATE_N 25

#define DEF_PITCH_RATE_P 0.0814044317697523
#define DEF_PITCH_RATE_I 0.00870812929848287
#define DEF_PITCH_RATE_D 0
#define PITCH_RATE_N 25

#define DEF_YAW_RATE_P 0.08280886
#define DEF_YAW_RATE_I 0
#define DEF_YAW_RATE_D 0
#define YAW_RATE_N 25

#define DEF_ROLL_P 1.3185496217049
#define DEF_ROLL_I 0
#define DEF_ROLL_D 0
#define ROLL_N 25

#define DEF_PITCH_P 1.3185496217049
#define DEF_PITCH_I 0
#define DEF_PITCH_D 0
#define PITCH_N 25

#define VEL_X_P -0.15
#define VEL_X_I 0
#define VEL_X_D 0
#define VEL_X_N 25

#define VEL_Y_P 0.15
#define VEL_Y_I 0
#define VEL_Y_D 0
#define VEL_Y_N 25

#define VEL_Z_P -0.2
#define VEL_Z_I 0
#define VEL_Z_D 0
#define VEL_Z_N 25

#define VEL_Z_TRIM 0.53

#define VEL_X_ERR_LIM 4
#define VEL_Y_ERR_LIM 4
#define VEL_Z_ERR_LIM 1

#define ROLL_RATE_SC PI
#define PITCH_RATE_SC PI
#define YAW_RATE_SC PI
#define ROLL_SC PI/4
#define PITCH_SC PI/4
#define VEL_X_SC 4
#define VEL_Y_SC 4
#define VEL_Z_SC 1

typedef enum {
	ROLL_RATE_P,
	ROLL_RATE_I,
	ROLL_RATE_D,
	PITCH_RATE_P,
	PITCH_RATE_I,
	PITCH_RATE_D,
	YAW_RATE_P,
	YAW_RATE_I,
	YAW_RATE_D,
	ROLL_P,
	ROLL_I,
	ROLL_D,
	PITCH_P,
	PITCH_I,
	PITCH_D,
}PID_params_t;

typedef struct {
	float32 Xd, Xi;
	float32 y;
	float32 Ts, P, I, D, N;
}PID_controller_t;

void read_PID_params();
void write_PID_params();
void adjust_PID(PID_params_t PID, float32 value);
void set_vel_x_ref(float32 cmd);
void set_vel_y_ref(float32 cmd);
void set_vel_z_ref(float32 cmd);
void set_roll_ref(float32 cmd);
void set_pitch_ref(float32 cmd);
void set_roll_rate_ref(float32 cmd);
void set_pitch_rate_ref(float32 cmd);
void set_yaw_rate_ref(float32 cmd);
void set_thr_ref(float32 cmd);
void control_reset();
void control_step();
void init_PID(PID_controller_t* PID, float32 Ts, float32 P, float32 I, float32 D, float32 N);
float32 PID_step(PID_controller_t* PID, float32 u);
void print_PID();

#endif /* USER_CODE_CONTROL_H_ */
